<?php

namespace App\Http\Resources\Web;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class TherapistsResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $therapist_settings = $this->relationLoaded('therapist_settings') ? $this->whenLoaded('therapist_settings') : null;
        $therapist_categories = $this->relationLoaded('therapist_categories') ? $this->whenLoaded('therapist_categories') : null;
        $therapist_broadcasts = $this->relationLoaded('therapist_broadcasts') ? $this->whenLoaded('therapist_broadcasts') : null;
        $therapist_podcasts = $this->relationLoaded('therapist_podcasts') ? $this->whenLoaded('therapist_podcasts') : null;
        $therapist_services = $this->relationLoaded('therapist_services') ? $this->whenLoaded('therapist_services') : null;
        $therapist_events = $this->relationLoaded('therapist_events') ? $this->whenLoaded('therapist_events') : null;
        $therapist_posts = $this->relationLoaded('therapist_posts') ? $this->whenLoaded('therapist_posts') : null;
        $therapist_archives = $this->relationLoaded('therapist_archives') ? $this->whenLoaded('therapist_archives') : null;
        $therapist_reviews = $this->relationLoaded('therapist_reviews') ? $this->whenLoaded('therapist_reviews') : null;
        $pricing_plan = $this->relationLoaded('pricing_plan') ? $this->whenLoaded('pricing_plan') : null;
        $country = $this->relationLoaded('country') ? $this->whenLoaded('country') : null;
        $state = $this->relationLoaded('state') ? $this->whenLoaded('state') : null;
        $city = $this->relationLoaded('city') ? $this->whenLoaded('city') : null;
        $languages = $this->relationLoaded('languages') ? $this->whenLoaded('languages') : null;
        $appointment_schedules = $this->relationLoaded('appointment_schedules') ? $this->whenLoaded('appointment_schedules') : null;
        $tags = $this->relationLoaded('tags') ? $this->whenLoaded('tags') : null;
        $user = $this->relationLoaded('user') ? $this->whenLoaded('user') : null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community') : null;
        if ($therapist_reviews) {
            $rating = $therapist_reviews->avg('rating');
            if (!$rating) {
                $rating = 0;
            } else {
                $rating = round($rating, 2);
            }
        } else {
            $rating = 0;
        }
        return [
            "id" => $this->id,
            "user_id" => $this->user_id,
            "therapist_community_id" => $this->therapist_community_id,
            "therapist_community_name" => $therapist_community->name ?? '',
            "country_id" => $this->country_id,
            "country_name" => $country ? $country->name : "",

            "state_id" => $this->state_id,
            "state_name" => $state ? $state->name : "",
            "city_id" => $this->city_id,
            "city_name" => $city ? $city->name : "",
            "distance" => $this->distance,

            "name" => $this->name,
            "first_name" => $this->first_name,
            "last_name" => $this->last_name,
            "description" => $this->description,
            "description_translations" =>  $this->getTranslations('description'),
            "experience" => $this->experience,
            "speciality" => $this->speciality,
            "address_line_1" => $this->address_line_1,
            "address_line_2" => $this->address_line_2,
            "user_name" => $this->user_name,
            "zip_code" => $this->zip_code,
            "is_approved" => $this->is_approved,
            "approved_at" => $this->approved_at,
            "is_active" => $this->is_active,
            "is_online" => $this->is_online,
            "is_premium" => $this->is_premium,
            "is_featured" => $this->is_featured,

            'prefix' => $this->prefix,
            'suffix' => $this->suffix,
            'home_phone' => $this->home_phone,
            'cell_phone' => $this->cell_phone,
            'job_title' => $this->job_title,
            'company' => $this->company,
            'website' => $this->website,
            'email' => $this->email,

            'billing_address_line_1' => $this->billing_address_line_1,
            'billing_address_line_2' => $this->billing_address_line_2,
            'billing_country_id' => $this->billing_country_id,
            'billing_state_id' => $this->billing_state_id,
            'billing_city_id' => $this->billing_city_id,
            'billing_zip_code' => $this->billing_zip_code,

            'shipping_address_line_1' => $this->shipping_address_line_1,
            'shipping_address_line_2' => $this->shipping_address_line_2,
            'shipping_country_id' => $this->shipping_country_id,
            'shipping_state_id' => $this->shipping_state_id,
            'shipping_city_id' => $this->shipping_city_id,
            'shipping_zip_code' => $this->shipping_zip_code,

            'work_address_line_1' => $this->work_address_line_1,
            'work_address_line_2' => $this->work_address_line_2,
            'work_country_id' => $this->work_country_id,
            'work_state_id' => $this->work_state_id,
            'work_city_id' => $this->work_city_id,
            'work_zip_code' => $this->work_zip_code,
            'is_special' => $this->is_special,

            "icon" => $this->icon,
            "image" => $this->image,
            "cover_image" => $this->cover_image,
            "rating" => $rating,
            "pricing_plan_name" => $pricing_plan->name ?? "",
            "therapist_modules" => $pricing_plan ? $pricing_plan->therapist_modules()->pluck('pricing_plan_modules.module_code')->toArray() : [],
            "therapist_settings" => $therapist_settings ? TherapistSettingsResource::collection($this->whenLoaded('therapist_settings', function () {
                return $this->therapist_settings;
            }))->pluck('value', 'name')->toArray() : [],
            "therapist_category_ids" => $therapist_categories ? TherapistCategoriesResource::collection($this->whenLoaded('therapist_categories', function () {
                return $this->therapist_categories;
            }))->pluck('id')->toArray() : [],
            "therapist_categories" => $therapist_categories ? TherapistCategoriesResource::collection($therapist_categories) : [],
            "therapist_broadcasts" => $therapist_broadcasts ? BroadcastsResource::collection($therapist_broadcasts) : [],
            "therapist_podcasts" => $therapist_podcasts ? BroadcastsResource::collection($therapist_podcasts) : [],
            "therapist_services" => $therapist_services ? ServicesResource::collection($therapist_services) : [],
            "therapist_events" => $therapist_events ? EventsResource::collection($therapist_events) : [],
            "therapist_posts" => $therapist_posts ? PostsResource::collection($therapist_posts) : [],
            "therapist_archives" => $therapist_archives ? ArchivesResource::collection($therapist_archives) : [],
            "therapist_reviews" => $therapist_reviews ? TherapistReviewsResource::collection($therapist_reviews) : [],
            "appointment_types" => $appointment_schedules ? AppointmentSchedulesResource::collection($appointment_schedules)->keyBy('appointment_type.type') : [],

            "language_ids" => $languages ? AllLanguagesResource::collection($this->whenLoaded('languages', function () {
                return $this->languages;
            }))->pluck('id')->toArray() : [],
            "tag_ids" => $tags ? TagsResource::collection($this->whenLoaded('tags', function () {
                return $this->tags;
            }))->pluck('id')->toArray() : [],
            "tags" => $tags ? TagsResource::collection($tags) : [],
            "user" => $user,

            "created_at" => Carbon::parse($this->created_at)->format('Y-m-d h:i:s'),
            "updated_at" => $this->updated_at,
        ];
    }
}
